/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.features.crystalcragsurface;

import blueduck.outerend.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.impl.Shapes;
import shadow.com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.BendLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.DilateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;

public class VioliteRockBumpFlowerFeature
extends Feature<NoFeatureConfig> {
    public VioliteRockBumpFlowerFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState VIOLITE = ((Block)BlockRegistry.VIOLITE.get()).func_176223_P();
        List<BlockState> WHITELIST = Arrays.asList(VIOLITE, Blocks.field_150350_a.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        pos = reader.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos);
        while (reader.func_175623_d(pos.func_177977_b()) && pos.func_177956_o() != 0) {
            pos = pos.func_177977_b();
        }
        if (reader.func_180495_p(pos.func_177977_b()) == VIOLITE) {
            int shards = random.nextInt(4) + 3;
            Shape shape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
            for (int s = 0; s < shards; ++s) {
                double maxRotationRange = 30.0;
                double rotation = (double)(360 / shards * s) + MathHelper.func_219803_d((double)random.nextDouble(), (double)(-maxRotationRange), (double)maxRotationRange);
                double length = random.nextDouble() * 15.0 + 12.0;
                double maxTiltChange = 15.0;
                double tilt = (double)(90 - 10 / shards * s) + MathHelper.func_219803_d((double)random.nextDouble(), (double)(-maxTiltChange), (double)maxTiltChange);
                double width = random.nextDouble() * 3.0 + 5.0;
                double height = random.nextDouble() * 3.0 + 3.5;
                double arcTurn = random.nextDouble() * 3.0;
                double maxTurnRange = 20.0;
                double turn = MathHelper.func_219803_d((double)random.nextDouble(), (double)(-maxTurnRange), (double)maxTurnRange);
                double scale = random.nextDouble() + 0.5;
                shape.applyLayer(new AddLayer(Shapes.ellipticalPyramid(width, height, length).applyLayer(new BendLayer(arcTurn, height, length)).applyLayer(new RotateLayer(Quaternion.of(turn, rotation, tilt, true))).applyLayer(new TranslateLayer(Position.of(0.0, -(width / 4.0), 0.0))))).applyLayer(new DilateLayer(Position.of(scale, scale, scale)));
            }
            shape.applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, VIOLITE)));
            return true;
        }
        return false;
    }
}

